IF OBJECT_ID('UFD_VALIDACAO_IMPOSTO_ETAPAS') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_VALIDACAO_IMPOSTO_ETAPAS
	END
	
GO
 
CREATE FUNCTION [DBO].[UFD_VALIDACAO_IMPOSTO_ETAPAS] (@CD_CTR INT)     

RETURNS @UFD_VALIDACAO_IMPOSTO_ETAPAS TABLE  (
	CD_CTR INT,
	CD_CTR_IT INT,
	ERRO_VALORES_XML_VERSUS_CADASTRO VARCHAR(8),
	ERRO_PARAMETRO_XML_VERSUS_CADASTRO VARCHAR(3),
	PENDENTE_XML_VERSUS_CADASTRO VARCHAR(3)
)

AS
BEGIN
/*
	--SELECT STRING_AGG(CAMPO_DANFE + '_TIPO_TRAT INT', ','),
	-- STRING_AGG(CAMPO_DANFE + '_MONETARIO INT', ','),
	-- STRING_AGG(CAMPO_DANFE + '_LIMITE_MON MONEY', ',')
	SELECT STRING_AGG('MAX(A.' + CAMPO_DANFE + ') AS ' + CAMPO_DANFE + '_TIPO_TRAT', ','),
	STRING_AGG('MAX(A.' + CAMPO_DANFE + ') AS ' + CAMPO_DANFE + '_MONETARIO', ','),
	STRING_AGG('ISNULL(MAX(A.' + CAMPO_DANFE + '),0) AS ' + CAMPO_DANFE + '_LIMITE_MON', ',')
	--SELECT STRING_AGG(CAMPO_DANFE, ',')
	FROM EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_CAMPOS_DANFE
*/

	DECLARE @CAMPOS_DANFE_TIPO_TRAT TABLE (CD_CTR INT,
		CST_ICMS_TIPO_TRAT INT,ALIQUOTA_ICMS_TIPO_TRAT INT,VALOR_BASE_ICMS_TIPO_TRAT INT,VALOR_ICMS_TIPO_TRAT INT,PERC_IVA_ST_TIPO_TRAT INT,ALIQUOTA_ICMS_ST_TIPO_TRAT INT,VALOR_BASE_ICMS_ST_TIPO_TRAT INT,VALOR_ICMS_ST_TIPO_TRAT INT,ALIQUOTA_IPI_TIPO_TRAT INT,VALOR_BASE_IPI_TIPO_TRAT INT,VALOR_IPI_TIPO_TRAT INT,PERC_RED_BASE_ICMS_TIPO_TRAT INT,PERC_RED_BASE_ICMS_ST_TIPO_TRAT INT,VALOR_BASE_ICMS_RET_TIPO_TRAT INT,VALOR_ICMS_RET_TIPO_TRAT INT,VALOR_BASE_FECOP_ST_TIPO_TRAT INT,PERC_FECOP_ST_TIPO_TRAT INT,VALOR_FECOP_ST_TIPO_TRAT INT,VALOR_BASE_FECOP_ST_RET_TIPO_TRAT INT,PERC_FECOP_ST_RET_TIPO_TRAT INT,VALOR_FECOP_ST_RET_TIPO_TRAT INT,VALOR_BASE_FECOP_TIPO_TRAT INT,PERC_FECOP_TIPO_TRAT INT,VALOR_FECOP_TIPO_TRAT INT,NCM_TIPO_TRAT INT
	)
	
	DECLARE @CAMPOS_DANFE_MONETARIO TABLE (CD_CTR INT,  
		CST_ICMS_MONETARIO INT,ALIQUOTA_ICMS_MONETARIO INT,VALOR_BASE_ICMS_MONETARIO INT,VALOR_ICMS_MONETARIO INT,PERC_IVA_ST_MONETARIO INT,ALIQUOTA_ICMS_ST_MONETARIO INT,VALOR_BASE_ICMS_ST_MONETARIO INT,VALOR_ICMS_ST_MONETARIO INT,ALIQUOTA_IPI_MONETARIO INT,VALOR_BASE_IPI_MONETARIO INT,VALOR_IPI_MONETARIO INT,PERC_RED_BASE_ICMS_MONETARIO INT,PERC_RED_BASE_ICMS_ST_MONETARIO INT,VALOR_BASE_ICMS_RET_MONETARIO INT,VALOR_ICMS_RET_MONETARIO INT,VALOR_BASE_FECOP_ST_MONETARIO INT,PERC_FECOP_ST_MONETARIO INT,VALOR_FECOP_ST_MONETARIO INT,VALOR_BASE_FECOP_ST_RET_MONETARIO INT,PERC_FECOP_ST_RET_MONETARIO INT,VALOR_FECOP_ST_RET_MONETARIO INT,VALOR_BASE_FECOP_MONETARIO INT,PERC_FECOP_MONETARIO INT,VALOR_FECOP_MONETARIO INT,NCM_MONETARIO INT
	)

	DECLARE @CAMPOS_DANFE_LIMITE_MON TABLE (CD_CTR INT,  
		CST_ICMS_LIMITE_MON MONEY,ALIQUOTA_ICMS_LIMITE_MON MONEY,VALOR_BASE_ICMS_LIMITE_MON MONEY,VALOR_ICMS_LIMITE_MON MONEY,PERC_IVA_ST_LIMITE_MON MONEY,ALIQUOTA_ICMS_ST_LIMITE_MON MONEY,VALOR_BASE_ICMS_ST_LIMITE_MON MONEY,VALOR_ICMS_ST_LIMITE_MON MONEY,ALIQUOTA_IPI_LIMITE_MON MONEY,VALOR_BASE_IPI_LIMITE_MON MONEY,VALOR_IPI_LIMITE_MON MONEY,PERC_RED_BASE_ICMS_LIMITE_MON MONEY,PERC_RED_BASE_ICMS_ST_LIMITE_MON MONEY,VALOR_BASE_ICMS_RET_LIMITE_MON MONEY,VALOR_ICMS_RET_LIMITE_MON MONEY,VALOR_BASE_FECOP_ST_LIMITE_MON MONEY,PERC_FECOP_ST_LIMITE_MON MONEY,VALOR_FECOP_ST_LIMITE_MON MONEY,VALOR_BASE_FECOP_ST_RET_LIMITE_MON MONEY,PERC_FECOP_ST_RET_LIMITE_MON MONEY,VALOR_FECOP_ST_RET_LIMITE_MON MONEY,VALOR_BASE_FECOP_LIMITE_MON MONEY,PERC_FECOP_LIMITE_MON MONEY,VALOR_FECOP_LIMITE_MON MONEY,NCM_LIMITE_MON MONEY
	)

	INSERT INTO @CAMPOS_DANFE_TIPO_TRAT
	SELECT B.CD_CTR, --B.CD_CTR_IT,
	MAX(A.CST_ICMS) AS CST_ICMS_TIPO_TRAT,MAX(A.ALIQUOTA_ICMS) AS ALIQUOTA_ICMS_TIPO_TRAT,MAX(A.VALOR_BASE_ICMS) AS VALOR_BASE_ICMS_TIPO_TRAT,MAX(A.VALOR_ICMS) AS VALOR_ICMS_TIPO_TRAT,MAX(A.PERC_IVA_ST) AS PERC_IVA_ST_TIPO_TRAT,MAX(A.ALIQUOTA_ICMS_ST) AS ALIQUOTA_ICMS_ST_TIPO_TRAT,MAX(A.VALOR_BASE_ICMS_ST) AS VALOR_BASE_ICMS_ST_TIPO_TRAT,MAX(A.VALOR_ICMS_ST) AS VALOR_ICMS_ST_TIPO_TRAT,MAX(A.ALIQUOTA_IPI) AS ALIQUOTA_IPI_TIPO_TRAT,MAX(A.VALOR_BASE_IPI) AS VALOR_BASE_IPI_TIPO_TRAT,MAX(A.VALOR_IPI) AS VALOR_IPI_TIPO_TRAT,MAX(A.PERC_RED_BASE_ICMS) AS PERC_RED_BASE_ICMS_TIPO_TRAT,MAX(A.PERC_RED_BASE_ICMS_ST) AS PERC_RED_BASE_ICMS_ST_TIPO_TRAT,MAX(A.VALOR_BASE_ICMS_RET) AS VALOR_BASE_ICMS_RET_TIPO_TRAT,MAX(A.VALOR_ICMS_RET) AS VALOR_ICMS_RET_TIPO_TRAT,MAX(A.VALOR_BASE_FECOP_ST) AS VALOR_BASE_FECOP_ST_TIPO_TRAT,MAX(A.PERC_FECOP_ST) AS PERC_FECOP_ST_TIPO_TRAT,MAX(A.VALOR_FECOP_ST) AS VALOR_FECOP_ST_TIPO_TRAT,MAX(A.VALOR_BASE_FECOP_ST_RET) AS VALOR_BASE_FECOP_ST_RET_TIPO_TRAT,MAX(A.PERC_FECOP_ST_RET) AS PERC_FECOP_ST_RET_TIPO_TRAT,MAX(A.VALOR_FECOP_ST_RET) AS VALOR_FECOP_ST_RET_TIPO_TRAT,MAX(A.VALOR_BASE_FECOP) AS VALOR_BASE_FECOP_TIPO_TRAT,MAX(A.PERC_FECOP) AS PERC_FECOP_TIPO_TRAT,MAX(A.VALOR_FECOP) AS VALOR_FECOP_TIPO_TRAT,MAX(A.NCM) AS NCM_TIPO_TRAT
	FROM (
		SELECT *
		FROM EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_CAMPOS_DANFE
		PIVOT(
			MAX(TIPO_TRATATIVA)
			FOR CAMPO_DANFE IN (CST_ICMS,ALIQUOTA_ICMS,VALOR_BASE_ICMS,VALOR_ICMS,PERC_IVA_ST,ALIQUOTA_ICMS_ST,VALOR_BASE_ICMS_ST,VALOR_ICMS_ST,ALIQUOTA_IPI,VALOR_BASE_IPI,VALOR_IPI,PERC_RED_BASE_ICMS,PERC_RED_BASE_ICMS_ST,VALOR_BASE_ICMS_RET,VALOR_ICMS_RET,VALOR_BASE_FECOP_ST,PERC_FECOP_ST,VALOR_FECOP_ST,VALOR_BASE_FECOP_ST_RET,PERC_FECOP_ST_RET,VALOR_FECOP_ST_RET,VALOR_BASE_FECOP,PERC_FECOP,VALOR_FECOP,NCM)
		) AS PIVO
	) AS A, EST_NF_ENT_DANFE_PROVISORIO B
	WHERE B.CD_CTR = @CD_CTR
	GROUP BY B.CD_CTR--, B.CD_CTR_IT

	INSERT INTO @CAMPOS_DANFE_MONETARIO
	SELECT B.CD_CTR, --B.CD_CTR_IT,
	MAX(A.CST_ICMS) AS CST_ICMS_MONETARIO,MAX(A.ALIQUOTA_ICMS) AS ALIQUOTA_ICMS_MONETARIO,MAX(A.VALOR_BASE_ICMS) AS VALOR_BASE_ICMS_MONETARIO,MAX(A.VALOR_ICMS) AS VALOR_ICMS_MONETARIO,MAX(A.PERC_IVA_ST) AS PERC_IVA_ST_MONETARIO,MAX(A.ALIQUOTA_ICMS_ST) AS ALIQUOTA_ICMS_ST_MONETARIO,MAX(A.VALOR_BASE_ICMS_ST) AS VALOR_BASE_ICMS_ST_MONETARIO,MAX(A.VALOR_ICMS_ST) AS VALOR_ICMS_ST_MONETARIO,MAX(A.ALIQUOTA_IPI) AS ALIQUOTA_IPI_MONETARIO,MAX(A.VALOR_BASE_IPI) AS VALOR_BASE_IPI_MONETARIO,MAX(A.VALOR_IPI) AS VALOR_IPI_MONETARIO,MAX(A.PERC_RED_BASE_ICMS) AS PERC_RED_BASE_ICMS_MONETARIO,MAX(A.PERC_RED_BASE_ICMS_ST) AS PERC_RED_BASE_ICMS_ST_MONETARIO,MAX(A.VALOR_BASE_ICMS_RET) AS VALOR_BASE_ICMS_RET_MONETARIO,MAX(A.VALOR_ICMS_RET) AS VALOR_ICMS_RET_MONETARIO,MAX(A.VALOR_BASE_FECOP_ST) AS VALOR_BASE_FECOP_ST_MONETARIO,MAX(A.PERC_FECOP_ST) AS PERC_FECOP_ST_MONETARIO,MAX(A.VALOR_FECOP_ST) AS VALOR_FECOP_ST_MONETARIO,MAX(A.VALOR_BASE_FECOP_ST_RET) AS VALOR_BASE_FECOP_ST_RET_MONETARIO,MAX(A.PERC_FECOP_ST_RET) AS PERC_FECOP_ST_RET_MONETARIO,MAX(A.VALOR_FECOP_ST_RET) AS VALOR_FECOP_ST_RET_MONETARIO,MAX(A.VALOR_BASE_FECOP) AS VALOR_BASE_FECOP_MONETARIO,MAX(A.PERC_FECOP) AS PERC_FECOP_MONETARIO,MAX(A.VALOR_FECOP) AS VALOR_FECOP_MONETARIO,MAX(A.NCM) AS NCM_MONETARIO
	FROM (
		SELECT *
		FROM EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_CAMPOS_DANFE
		PIVOT(
			MAX(CAMPO_MONETARIO)
			FOR CAMPO_DANFE IN (CST_ICMS,ALIQUOTA_ICMS,VALOR_BASE_ICMS,VALOR_ICMS,PERC_IVA_ST,ALIQUOTA_ICMS_ST,VALOR_BASE_ICMS_ST,VALOR_ICMS_ST,ALIQUOTA_IPI,VALOR_BASE_IPI,VALOR_IPI,PERC_RED_BASE_ICMS,PERC_RED_BASE_ICMS_ST,VALOR_BASE_ICMS_RET,VALOR_ICMS_RET,VALOR_BASE_FECOP_ST,PERC_FECOP_ST,VALOR_FECOP_ST,VALOR_BASE_FECOP_ST_RET,PERC_FECOP_ST_RET,VALOR_FECOP_ST_RET,VALOR_BASE_FECOP,PERC_FECOP,VALOR_FECOP,NCM)
		) AS PIVO
	) AS A, EST_NF_ENT_DANFE_PROVISORIO B
	WHERE B.CD_CTR = @CD_CTR -- 1843485
	GROUP BY B.CD_CTR--, B.CD_CTR_IT

	INSERT INTO @CAMPOS_DANFE_LIMITE_MON
	SELECT B.CD_CTR, --B.CD_CTR_IT,
	ISNULL(MAX(A.CST_ICMS),0) AS CST_ICMS_LIMITE_MON,ISNULL(MAX(A.ALIQUOTA_ICMS),0) AS ALIQUOTA_ICMS_LIMITE_MON,ISNULL(MAX(A.VALOR_BASE_ICMS),0) AS VALOR_BASE_ICMS_LIMITE_MON,ISNULL(MAX(A.VALOR_ICMS),0) AS VALOR_ICMS_LIMITE_MON,ISNULL(MAX(A.PERC_IVA_ST),0) AS PERC_IVA_ST_LIMITE_MON,ISNULL(MAX(A.ALIQUOTA_ICMS_ST),0) AS ALIQUOTA_ICMS_ST_LIMITE_MON,ISNULL(MAX(A.VALOR_BASE_ICMS_ST),0) AS VALOR_BASE_ICMS_ST_LIMITE_MON,ISNULL(MAX(A.VALOR_ICMS_ST),0) AS VALOR_ICMS_ST_LIMITE_MON,ISNULL(MAX(A.ALIQUOTA_IPI),0) AS ALIQUOTA_IPI_LIMITE_MON,ISNULL(MAX(A.VALOR_BASE_IPI),0) AS VALOR_BASE_IPI_LIMITE_MON,ISNULL(MAX(A.VALOR_IPI),0) AS VALOR_IPI_LIMITE_MON,ISNULL(MAX(A.PERC_RED_BASE_ICMS),0) AS PERC_RED_BASE_ICMS_LIMITE_MON,ISNULL(MAX(A.PERC_RED_BASE_ICMS_ST),0) AS PERC_RED_BASE_ICMS_ST_LIMITE_MON,ISNULL(MAX(A.VALOR_BASE_ICMS_RET),0) AS VALOR_BASE_ICMS_RET_LIMITE_MON,ISNULL(MAX(A.VALOR_ICMS_RET),0) AS VALOR_ICMS_RET_LIMITE_MON,ISNULL(MAX(A.VALOR_BASE_FECOP_ST),0) AS VALOR_BASE_FECOP_ST_LIMITE_MON,ISNULL(MAX(A.PERC_FECOP_ST),0) AS PERC_FECOP_ST_LIMITE_MON,ISNULL(MAX(A.VALOR_FECOP_ST),0) AS VALOR_FECOP_ST_LIMITE_MON,ISNULL(MAX(A.VALOR_BASE_FECOP_ST_RET),0) AS VALOR_BASE_FECOP_ST_RET_LIMITE_MON,ISNULL(MAX(A.PERC_FECOP_ST_RET),0) AS PERC_FECOP_ST_RET_LIMITE_MON,ISNULL(MAX(A.VALOR_FECOP_ST_RET),0) AS VALOR_FECOP_ST_RET_LIMITE_MON,ISNULL(MAX(A.VALOR_BASE_FECOP),0) AS VALOR_BASE_FECOP_LIMITE_MON,ISNULL(MAX(A.PERC_FECOP),0) AS PERC_FECOP_LIMITE_MON,ISNULL(MAX(A.VALOR_FECOP),0) AS VALOR_FECOP_LIMITE_MON,ISNULL(MAX(A.NCM),0) AS NCM_LIMITE_MON
	FROM (
		SELECT *
		FROM EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_CAMPOS_DANFE
		PIVOT(
			MAX(LIMITE_ACEITAVEL_DIVERGENCIA)
			FOR CAMPO_DANFE IN (CST_ICMS,ALIQUOTA_ICMS,VALOR_BASE_ICMS,VALOR_ICMS,PERC_IVA_ST,ALIQUOTA_ICMS_ST,VALOR_BASE_ICMS_ST,VALOR_ICMS_ST,ALIQUOTA_IPI,VALOR_BASE_IPI,VALOR_IPI,PERC_RED_BASE_ICMS,PERC_RED_BASE_ICMS_ST,VALOR_BASE_ICMS_RET,VALOR_ICMS_RET,VALOR_BASE_FECOP_ST,PERC_FECOP_ST,VALOR_FECOP_ST,VALOR_BASE_FECOP_ST_RET,PERC_FECOP_ST_RET,VALOR_FECOP_ST_RET,VALOR_BASE_FECOP,PERC_FECOP,VALOR_FECOP,NCM)
		) AS PIVO
	) AS A, EST_NF_ENT_DANFE_PROVISORIO B
	WHERE B.CD_CTR = @CD_CTR
	GROUP BY B.CD_CTR--, B.CD_CTR_IT

	INSERT INTO @UFD_VALIDACAO_IMPOSTO_ETAPAS

	SELECT
	I.CD_CTR,
	I.CD_CTR_IT,
	CASE WHEN IVP.CD_CTR IS NULL THEN
		CASE WHEN IV.CD_CTR IS NULL THEN
			'SIM'
		ELSE
			'NAO'
		END 
	ELSE
		'PENDENTE'
	END AS ERRO_VALORES_XML_VERSUS_CADASTRO,
	CASE WHEN ISNULL((SELECT 
		TOP 1 ERR.CD_CTR 
     FROM 
		EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_ERROS_VALIDACAO ERR 
     WHERE 
		ERR.CD_CTR=I.CD_CTR),0) > 0 THEN
	    'SIM'
	 ELSE
	    'NAO'
	 END AS ERRO_PARAMETRO_XML_VERSUS_CADASTRO,

	CASE WHEN IVP.CD_CTR IS NULL THEN
		'NAO'
	ELSE
		'SIM'
	END AS PENDENTE_XML_VERSUS_CADASTRO
FROM 
	EST_NF_ENT_DANFE_PROVISORIO_ITENS I 
	INNER JOIN EST_PROD ON I.CD_EMP = EST_PROD.CD_EMP AND I.CD_PROD = EST_PROD.CD_PROD 
	JOIN @CAMPOS_DANFE_TIPO_TRAT T ON T.CD_CTR = I.CD_CTR
	JOIN @CAMPOS_DANFE_MONETARIO M ON M.CD_CTR = I.CD_CTR
	JOIN @CAMPOS_DANFE_LIMITE_MON L ON L.CD_CTR = I.CD_CTR
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PENDENTE IVP ON
	I.CD_CTR=IVP.CD_CTR AND
	I.CD_CTR_IT=IVP.CD_CTR_IT 
	LEFT OUTER JOIN  EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO IV ON
	I.CD_CTR=IV.CD_CTR AND
	I.CD_CTR_IT=IV.CD_CTR_IT AND
    (
        T.CST_ICMS_TIPO_TRAT <> 1
        OR
        (
            (M.CST_ICMS_MONETARIO = 0 AND I.CD_TRIB = IV.CD_TRIB)
            OR
            (M.CST_ICMS_MONETARIO = 1 AND ABS(I.CD_TRIB - IV.CD_TRIB) <= L.CST_ICMS_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_BASE_ICMS_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_BASE_ICMS_MONETARIO = 0 AND I.VLR_PROD_BASE_ICMS = IV.VLR_PROD_BASE_ICMS)
            OR
            (M.VALOR_BASE_ICMS_MONETARIO = 1 AND ABS(I.VLR_PROD_BASE_ICMS - IV.VLR_PROD_BASE_ICMS) <= L.VALOR_BASE_ICMS_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_ICMS_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_ICMS_MONETARIO = 0 AND I.VLR_PROD_ICMS = IV.VLR_PROD_ICMS)
            OR
            (M.VALOR_ICMS_MONETARIO = 1 AND ABS(I.VLR_PROD_ICMS - IV.VLR_PROD_ICMS) <= L.VALOR_ICMS_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_BASE_IPI_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_BASE_IPI_MONETARIO = 0 AND I.VLR_PROD_BASE_IPI = IV.VLR_PROD_BASE_IPI)
            OR
            (M.VALOR_BASE_IPI_MONETARIO = 1 AND ABS(I.VLR_PROD_BASE_IPI - IV.VLR_PROD_BASE_IPI) <= L.VALOR_BASE_IPI_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_IPI_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_IPI_MONETARIO = 0 AND I.VLR_PROD_IPI = IV.VLR_PROD_IPI)
            OR
            (M.VALOR_IPI_MONETARIO = 1 AND ABS(I.VLR_PROD_IPI - IV.VLR_PROD_IPI) <= L.VALOR_IPI_LIMITE_MON)
        )
    ) AND
    (
        T.ALIQUOTA_IPI_TIPO_TRAT <> 1
        OR
        (
            (M.ALIQUOTA_IPI_MONETARIO = 0 AND I.PERC_PROD_IPI = IV.PERC_PROD_IPI)
            OR
            (M.ALIQUOTA_IPI_MONETARIO = 1 AND ABS(I.PERC_PROD_IPI - IV.PERC_PROD_IPI) <= L.ALIQUOTA_IPI_LIMITE_MON)
        )
    ) AND
    (
        T.ALIQUOTA_ICMS_TIPO_TRAT <> 1
        OR
        (
            (M.ALIQUOTA_ICMS_MONETARIO = 0 AND I.PERC_PROD_ICMS = IV.PERC_PROD_ICMS)
            OR
            (M.ALIQUOTA_ICMS_MONETARIO = 1 AND ABS(I.PERC_PROD_ICMS - IV.PERC_PROD_ICMS) <= L.ALIQUOTA_ICMS_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_BASE_ICMS_ST_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_BASE_ICMS_ST_MONETARIO = 0 AND I.VLR_PROD_BASE_ST = IV.VLR_PROD_BASE_ST)
            OR
            (M.VALOR_BASE_ICMS_ST_MONETARIO = 1 AND ABS(I.VLR_PROD_BASE_ST - IV.VLR_PROD_BASE_ST) <= L.VALOR_BASE_ICMS_ST_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_ICMS_ST_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_ICMS_ST_MONETARIO = 0 AND I.VLR_PROD_ICMS_ST = IV.VLR_PROD_ICMS_ST)
            OR
            (M.VALOR_ICMS_ST_MONETARIO = 1 AND ABS(I.VLR_PROD_ICMS_ST - IV.VLR_PROD_ICMS_ST) <= L.VALOR_ICMS_ST_LIMITE_MON)
        )
    ) AND
    (
        T.PERC_IVA_ST_TIPO_TRAT <> 1
        OR
        (
            (M.PERC_IVA_ST_MONETARIO = 0 AND I.PERC_PROD_IVA_ST = IV.PERC_PROD_IVA_ST)
            OR
            (M.PERC_IVA_ST_MONETARIO = 1 AND ABS(I.PERC_PROD_IVA_ST - IV.PERC_PROD_IVA_ST) <= L.PERC_IVA_ST_LIMITE_MON)
        )
    ) AND
    (
        T.PERC_RED_BASE_ICMS_TIPO_TRAT <> 1
        OR
        (
            (M.PERC_RED_BASE_ICMS_MONETARIO = 0 AND I.PERC_PROD_RED_BASE_ICMS = IV.PERC_PROD_RED_BASE_ICMS)
            OR
            (M.PERC_RED_BASE_ICMS_MONETARIO = 1 AND ABS(I.PERC_PROD_RED_BASE_ICMS - IV.PERC_PROD_RED_BASE_ICMS) <= L.PERC_RED_BASE_ICMS_LIMITE_MON)
        )
    ) AND
    (
        T.PERC_RED_BASE_ICMS_ST_TIPO_TRAT <> 1
        OR
        (
            (M.PERC_RED_BASE_ICMS_ST_MONETARIO = 0 AND I.PERC_PROD_RED_BASE_ST = IV.PERC_PROD_RED_BASE_ST)
            OR
            (M.PERC_RED_BASE_ICMS_ST_MONETARIO = 1 AND ABS(I.PERC_PROD_RED_BASE_ST - IV.PERC_PROD_RED_BASE_ST) <= L.PERC_RED_BASE_ICMS_ST_LIMITE_MON)
        )
    ) AND
    (
        T.ALIQUOTA_ICMS_ST_TIPO_TRAT <> 1
        OR
        (
            (M.ALIQUOTA_ICMS_ST_MONETARIO = 0 AND I.PERC_PROD_ICMS_ST = IV.PERC_PROD_ICMS_ST)
            OR
            (M.ALIQUOTA_ICMS_ST_MONETARIO = 1 AND ABS(I.PERC_PROD_ICMS_ST - IV.PERC_PROD_ICMS_ST) <= L.ALIQUOTA_ICMS_ST_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_BASE_ICMS_RET_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_BASE_ICMS_RET_MONETARIO = 0 AND I.VLR_BASE_ICMS_RET = IV.VLR_BASE_ICMS_RET)
            OR
            (M.VALOR_BASE_ICMS_RET_MONETARIO = 1 AND ABS(I.VLR_BASE_ICMS_RET - IV.VLR_BASE_ICMS_RET) <= L.VALOR_BASE_ICMS_RET_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_ICMS_RET_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_ICMS_RET_MONETARIO = 0 AND I.VLR_ICMS_RET = IV.VLR_ICMS_RET)
            OR
            (M.VALOR_ICMS_RET_MONETARIO = 1 AND ABS(I.VLR_ICMS_RET - IV.VLR_ICMS_RET) <= L.VALOR_ICMS_RET_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_BASE_FECOP_ST_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_BASE_FECOP_ST_MONETARIO = 0 AND I.VLR_BASE_FECOP_ST = IV.VLR_BASE_FECOP_ST)
            OR
            (M.VALOR_BASE_FECOP_ST_MONETARIO = 1 AND ABS(I.VLR_BASE_FECOP_ST - IV.VLR_BASE_FECOP_ST) <= L.VALOR_BASE_FECOP_ST_LIMITE_MON)
        )
    ) AND
    (
        T.PERC_FECOP_ST_TIPO_TRAT <> 1
        OR
        (
            (M.PERC_FECOP_ST_MONETARIO = 0 AND I.PERC_FECOP_ST = IV.PERC_FECOP_ST)
            OR
            (M.PERC_FECOP_ST_MONETARIO = 1 AND ABS(I.PERC_FECOP_ST - IV.PERC_FECOP_ST) <= L.PERC_FECOP_ST_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_FECOP_ST_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_FECOP_ST_MONETARIO = 0 AND I.VLR_FECOP_ST = IV.VLR_FECOP_ST)
            OR
            (M.VALOR_FECOP_ST_MONETARIO = 1 AND ABS(I.VLR_FECOP_ST - IV.VLR_FECOP_ST) <= L.VALOR_FECOP_ST_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_BASE_FECOP_ST_RET_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_BASE_FECOP_ST_RET_MONETARIO = 0 AND I.VLR_BASE_FECOP_ST_RET = IV.VLR_BASE_FECOP_ST_RET)
            OR
            (M.VALOR_BASE_FECOP_ST_RET_MONETARIO = 1 AND ABS(I.VLR_BASE_FECOP_ST_RET - IV.VLR_BASE_FECOP_ST_RET) <= L.VALOR_BASE_FECOP_ST_RET_LIMITE_MON)
        )
    ) AND
    (
        T.PERC_FECOP_ST_RET_TIPO_TRAT <> 1
        OR
        (
            (M.PERC_FECOP_ST_RET_MONETARIO = 0 AND I.PERC_FECOP_ST_RET = IV.PERC_FECOP_ST_RET)
            OR
            (M.PERC_FECOP_ST_RET_MONETARIO = 1 AND ABS(I.PERC_FECOP_ST_RET - IV.PERC_FECOP_ST_RET) <= L.PERC_FECOP_ST_RET_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_FECOP_ST_RET_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_FECOP_ST_RET_MONETARIO = 0 AND I.VLR_FECOP_ST_RET = IV.VLR_FECOP_ST_RET)
            OR
            (M.VALOR_FECOP_ST_RET_MONETARIO = 1 AND ABS(I.VLR_FECOP_ST_RET - IV.VLR_FECOP_ST_RET) <= L.VALOR_FECOP_ST_RET_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_BASE_FECOP_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_BASE_FECOP_MONETARIO = 0 AND I.VLR_BASE_FECOP = IV.VLR_BASE_FECOP)
            OR
            (M.VALOR_BASE_FECOP_MONETARIO = 1 AND ABS(I.VLR_BASE_FECOP - IV.VLR_BASE_FECOP) <= L.VALOR_BASE_FECOP_LIMITE_MON)
        )
    ) AND
    (
        T.PERC_FECOP_TIPO_TRAT <> 1
        OR
        (
            (M.PERC_FECOP_MONETARIO = 0 AND I.PERC_FECOP = IV.PERC_FECOP)
            OR
            (M.PERC_FECOP_MONETARIO = 1 AND ABS(I.PERC_FECOP - IV.PERC_FECOP) <= L.PERC_FECOP_LIMITE_MON)
        )
    ) AND
    (
        T.VALOR_FECOP_TIPO_TRAT <> 1
        OR
        (
            (M.VALOR_FECOP_MONETARIO = 0 AND I.VLR_FECOP = IV.VLR_FECOP)
            OR
            (M.VALOR_FECOP_MONETARIO = 1 AND ABS(I.VLR_FECOP - IV.VLR_FECOP) <= L.VALOR_FECOP_LIMITE_MON)
        )
    ) AND
	(
        T.NCM_TIPO_TRAT <> 1
        OR
        (
            (M.NCM_MONETARIO = 0 AND I.NCM = EST_PROD.NR_NCM)
            --OR
            --(M.NCM_MONETARIO = 1 AND ABS(I.NCM - EST_PROD.NR_NCM) <= L.NCM_LIMITE_MON)
        )
    )

	WHERE I.CD_CTR = @CD_CTR

	RETURN          

END           